#include <cstdlib>
#include <cstdio>

#include "lcphidget.h"

CPhidgetInterfaceKitHandle Lcphidget::convertToAddr(const char * phid, char ** endptr, int base)
{
	CPhidgetInterfaceKitHandle ifKit = (CPhidgetInterfaceKitHandle)strtoul(phid, NULL, base);		
	return ifKit;
}

void Lcphidget::returnOutcome(int outcome, char **r_result, Bool *r_pass, Bool *r_err){
	char outcome_str[8];
	sprintf(outcome_str, "%d", outcome);
	*r_result = strdup(outcome_str);
	*r_err = False;
	*r_pass = False;
	return;
}

int CCONV Lcphidget::Attach_Handler(CPhidgetHandle ifKit, void *userptr)
{
	int t_success;
	char * scmMsg;

	scmMsg=NULL;
	scmMsg = (char *)malloc(512);
	sprintf(scmMsg, "send \"%s %08x\" to current card", (char *)userptr, ifKit);
	SendCardMessage(scmMsg, &t_success);

	if (scmMsg != NULL)
		free(scmMsg);

	return 0;
}


int CCONV Lcphidget::Detach_Handler(CPhidgetHandle ifKit, void *userptr)
{
	int t_success;
	char * scmMsg;

	scmMsg=NULL;
	scmMsg = (char *)malloc(512);
	sprintf(scmMsg, "send \"%s %08x\" to current card", (char *)userptr, ifKit);
	SendCardMessage(scmMsg, &t_success);

	if (scmMsg != NULL)
		free(scmMsg);

	return 0;
}

int CCONV Lcphidget::Error_Handler(CPhidgetHandle ifKit, void *userptr, int ErrorCode, const char *unknown)
{
	int t_success;
	char * scmMsg;

	scmMsg=NULL;
	scmMsg = (char *)malloc(512);
	sprintf(scmMsg, "send \"%s %08x, %d, %s\" to current card", (char *)userptr, ifKit, ErrorCode, unknown);
	SendCardMessage(scmMsg, &t_success);

	if (scmMsg != NULL)
		free(scmMsg);

	return 0;
}




void Lcphidget::phidgets_set_OnAttach_Handler(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		

	char* str=(char *)malloc(90);
	str=strdup(p_arguments[1]);
	int outcome=CPhidget_set_OnAttach_Handler((CPhidgetHandle)ifKit, &Lcphidget::Attach_Handler, str);
	
	returnOutcome(outcome, r_result, r_pass, r_err);
}

void Lcphidget::phidgets_set_OnDetach_Handler(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		

	char* str=(char *)malloc(90);
	str=strdup(p_arguments[1]);
	int outcome=CPhidget_set_OnDetach_Handler((CPhidgetHandle)ifKit, &Lcphidget::Detach_Handler, str);
	
	returnOutcome(outcome, r_result, r_pass, r_err);
}

void Lcphidget::phidgets_set_OnError_Handler(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		

	char* str=(char *)malloc(90);
	str=strdup(p_arguments[1]);
	int outcome=CPhidget_set_OnError_Handler((CPhidgetHandle)ifKit, &Lcphidget::Error_Handler, str);
	
	returnOutcome(outcome, r_result, r_pass, r_err);
}


void Lcphidget::phidgets_open(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);	
	
	int outcome;
	
	if(atoi(p_arguments[1])==-1){
		 outcome = CPhidget_open((CPhidgetHandle)ifKit, -1);
	}
	else{
		 outcome = CPhidget_open((CPhidgetHandle)ifKit, atoi(p_arguments[1]));
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;

}

void Lcphidget::phidgets_close(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		

	int outcome = CPhidget_close((CPhidgetHandle)ifKit);
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;

}

void Lcphidget::phidgets_delete(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	
	int outcome = CPhidget_delete((CPhidgetHandle)ifKit);
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;

}

void Lcphidget::phidgets_getDeviceName(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success;
	const char *deviceName;

	int outcome = CPhidget_getDeviceName((CPhidgetHandle)ifKit, &deviceName);
	if(outcome==0){
		sprintf(str,"%s",deviceName);
		SetVariable(p_arguments[1], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;


}

void Lcphidget::phidgets_getSerialNumber(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success, serialNumber;

	int outcome = CPhidget_getSerialNumber((CPhidgetHandle)ifKit, &serialNumber);
	if(outcome==0){
		sprintf(str,"%d",serialNumber);
		SetVariable(p_arguments[1], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;


}

void Lcphidget::phidgets_getDeviceVersion(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success, deviceVersion;

	int outcome = CPhidget_getDeviceVersion((CPhidgetHandle)ifKit, &deviceVersion);
	if(outcome==0){
		sprintf(str,"%d",deviceVersion);
		SetVariable(p_arguments[1], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;


}

void Lcphidget::phidgets_getDeviceStatus(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success, deviceStatus;

	int outcome = CPhidget_getDeviceStatus((CPhidgetHandle)ifKit, &deviceStatus);
	if(outcome==0){
		sprintf(str,"%d",deviceStatus);
		SetVariable(p_arguments[1], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;

}

void Lcphidget::phidgets_waitForAttachment(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	const char *err;
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	int outcome = CPhidget_waitForAttachment((CPhidgetHandle)ifKit, atoi(p_arguments[1]));
	
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;
}

void Lcphidget::phidgets_getErrorDescription(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success;
	const char *errorString;

	int outcome = CPhidget_getErrorDescription (atoi(p_arguments[0]), &errorString);
	if(outcome==0){
		sprintf(str,"%s",errorString);
		SetVariable(p_arguments[1], str, &t_success);
	}

	returnOutcome(outcome, r_result, r_pass, r_err);
	return;

}



